import java.io.*;

/**
 * Classe contenente il main dell'applicazione client, 
 * fa tutte le registrazioni e si mette in ascolto delle richieste del cliente
 * @author Letizia Cheng Cheng Sun
 * @version 1.0
 *
 */

public class NewsgroupClientApplication {
	public static void main(String args[]) {
		try {
			InputStreamIn in=new InputStreamIn(); 
			ShowMessagePrompt show=new ShowMessagePrompt();
			InputStreamReader is = new InputStreamReader(in.getInputStream());
			BufferedReader br = new BufferedReader(is);
			String hostName,servName;
			int RMIPort;
			if(args.length!=0){
				if(args.length!=3){
					show.println("Usage java NewsgroupClientApplication <argNews> <hostname> <portNumber>");
					show.println("or");
					show.println("Usage java NewsgroupClientApplication");
					System.exit(1);
				}
				servName=args[0];
				hostName=args[1];
				String portNum =args[2];
				RMIPort = Integer.parseInt(portNum);
				
			}
			else{
				show.println("Enter the newsgroup argument:");
				servName = br.readLine();
				show.println("Enter the RMIRegistry host name:");
				hostName = br.readLine();
				show.println("Enter the RMIregistry port number:");
				String portNum = br.readLine();
				RMIPort = Integer.parseInt(portNum);
			}
			//Costruzione delle informazioni riguardo al registro a cui ci si connetter
			
			//Connessione al server
			INewsgroupServer server_ref =DoConnectionToServer.connect(RMIPort,hostName,servName);
			if(server_ref==null){
				show.println("Connection al server fallita");
				System.exit(3);
			}
			show.println("Lookup completed " );
			
			/* istanziazione implementazione interfaccia remota del client */
			show.println("nickname:");
			String nick = br.readLine();
			Person client;
			show.println("Vuoi immettere anche altri dati(Nome, cognome, email e descrizione)?\n"+
							"(S=si N=no)");
			String response=br.readLine();
			if(response.equalsIgnoreCase("s")){
				show.print("Nome:");
				String name=br.readLine();
				show.print("Cognome:");
				String surname=br.readLine();
				show.print("Email:");
				String email=br.readLine();
				show.print("Descrizione:");
				String descr=br.readLine();
				client=new Person(nick,name,surname,email,descr);
			}
			else
				client=new Person(nick);
			NewsgroupClientImpl client_ref =new NewsgroupClientImpl(client,
												new ShowMessagePrompt());
			
			/* registrazione al newsgroup */
			show.println("Registering for newsgroup");
			server_ref.registerNews(client_ref);
			
			/* ciclo di permanenza nel newsgroup */
			do{
				show.println("\n\nEOF per uscire: "+
						"\nS: vedere tutti i messaggi"+
						"\nW: scrivere un nuovo messaggio"+
						"\nR: leggere messaggi particolari"+
						"\nA: rispondere a un messaggio"+
						"\nRR:leggere risposte a un messaggio");
				String message=br.readLine();
				if(message==null)
					break;
				if (message.equalsIgnoreCase("s")){
					server_ref.read(client_ref);
				}
				if (message.equalsIgnoreCase("w")){
					show.print("oggetto:");
					String obj=br.readLine();			
					show.println("Puoi immettere ora il testo:");
					show.println("Premere ctrl+z in una nuova riga per terminare l'input");
					String body="";
					String b;
					while((b=br.readLine())!=null)
						body=body.concat(b+"\n");
					server_ref.writeMsg(client,obj,body,null,client_ref);
					continue;
				}
				if (message.equalsIgnoreCase("r")){
					show.println("Ricerca per ID(0),\n" +
							"oggetto(1),\n" +
							"mittente ed oggetto(2),\n");
					String metodo=br.readLine();
					int nMetodo=Integer.parseInt(metodo);
					switch(nMetodo){
						case(0):
							show.println("inserisci ID");
							String ID=br.readLine();
							server_ref.readIDMsg(client_ref,ID);
							break;
						case(1):
							show.println("inserisci oggetto:");
							String obj=br.readLine();
							server_ref.read(client_ref,obj);
							break;
						case(2):
							show.println("Inserisci dati del mittente:");
							show.println("nickname:");
							String nickname = br.readLine();
							Person sender;
							show.println("Vuoi immettere anche altri dati(Nome, cognome, email e descrizione)?\n"+
										"(S=si N=no)");
							String resp=br.readLine();
							if(resp.equalsIgnoreCase("s")){
								show.print("Nome:");
								String name=br.readLine();
								show.print("Cognome:");
								String surname=br.readLine();
								show.print("Email:");
								String email=br.readLine();
								show.print("Descrizione:");
								String descr=br.readLine();
								sender=new Person(nickname,name,surname,email,descr);
							}
							else
								sender=new Person(nickname);
							show.println("inserisci oggetto:");
							String obj1=br.readLine();
							server_ref.read(client_ref,sender,obj1);
							break;
						
						default:
							show.println("Errore:valori consentiti 0,1,2");
					}
					continue;
				}
				if (message.equalsIgnoreCase("a")){
					show.println("ID Messaggio a cui vuoi rispondere:");
					String ID=br.readLine();
					
					//-----------------------------------------------------------
					//CODICE PER TROVARE IL MESSAGGIO A CUI SI STA RISPONDENDO
					//----------------------------------------------------------
					Msg father=null;
					Msg[] msgs=client_ref.getMsgs();
					if(msgs!=null){
						for(int i=0;i<msgs.length;i++){
							if(msgs[i].getMsgID().equalsIgnoreCase(ID)){
								father=msgs[i];
								break;
							}
						}
					}
					if(father==null){
						show.println("Nessun messaggio con questo ID\n");
						continue;
					}
					show.println("\nMessaggio con ID="+ID+":\n");
					show.println(father);
					//fine metodo per trovare messaggio padre
					show.println("\npuoi immettere il testo della tua risposta:");
					show.println("Premere ctrl+z in una nuova riga per terminare l'input");
					String reBody="";
					String b;
					while((b=br.readLine())!=null)
						reBody=reBody.concat(b+"\n");
					
					server_ref.writeMsg(client,"Re:"+father.getObject(),reBody,father,client_ref);
					continue;
				}
				if (message.equalsIgnoreCase("rr")){
					show.println("Inserisci ID del messaggio di cui vuoi leggere le risposte:");
					String idMsg=br.readLine();
					server_ref.readResponse(client_ref,idMsg);
					continue;
				}
				
			}
			while (true);
			
			
			/* uscita dal newsgroup */
			server_ref.unregisterNews(client_ref);
			show.println("Unregistered from newsgroup.");
			System.exit(0);
		} // end try
		catch (Exception e) {
			System.out.println("Exception in NewsgroupClientApplication: " + e);
			System.exit(1);
		} // end catch
		

	} //end main
}